// AIbufferDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AIbuffer.h"
#include "AIbufferDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAIbufferDlg dialog

CAIbufferDlg::CAIbufferDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAIbufferDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAIbufferDlg)
	m_autoZero = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAIbufferDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAIbufferDlg)
	DDX_Control(pDX, IDC_START, m_startButton);
	DDX_Control(pDX, IDC_LIST1, m_readList);
	DDX_Check(pDX, IDC_AUTOZERO, m_autoZero);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAIbufferDlg, CDialog)
	//{{AFX_MSG_MAP(CAIbufferDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_QUIT, OnQuit)
	ON_BN_CLICKED(IDC_START, OnStart)
	ON_BN_CLICKED(IDC_OPEN_INIT, OnOpenInit)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAIbufferDlg message handlers

BOOL CAIbufferDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_pSR=NULL;
	m_driverInstance=NULL;

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAIbufferDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAIbufferDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAIbufferDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
	return;
}

void CAIbufferDlg::OnQuit() 
{
	// TODO: Add your control notification handler code here
	clearBuffers(); //de-allocate any existing buffers
	CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
	m_driverInstance=NULL; //for safety, make sure m_driverInstance isn't pointing to anything
	delete(m_pSR); //de-allocate the memory used by the service request
	m_pSR=NULL;
	OnOK(); //Close the application
	
}

void CAIbufferDlg::OnStart() 
{
	// TODO: Add your control notification handler code here
	m_startButton.EnableWindow(FALSE); //Disable the start button at the beginning, so it doesn't get restarted in the middle of the acquisition
	clearBuffers();	//de-allocate any exisiting buffers in the service request
	m_pSR->operation=START; //Start the acquisition
	m_pSR->subsystem=AI; //using the AI subsystem
	m_pSR->mode=INTERRUPT; 	// board also supports DMA mode
	m_pSR->taskFlags = NO_SERVICESTART; // can not block SERVICEDONE;
	m_pSR->start.typeEvent=COMMAND; //Start on command

	m_pSR->stop.typeEvent=TCEVENT; //Stop automatically when buffer is full
	m_pSR->channels.nChannels=2; //A start/stop range will be used

	// start channel number and gain
	m_pSR->channels.chanGain[0].channel=m_logicalChannel; //starting channel defined by m_logicalChannel
	m_pSR->channels.chanGain[0].gainOrRange=Gain2Code(m_logicalDevice,AI,-800.0); //Use bipolar range
	  // negative means bipolar 800 means gain of 800
	// stop channel number and gain
    m_pSR->channels.chanGain[1].channel=m_logicalChannel+7;  // stop on chan 7
	m_pSR->channels.chanGain[1].gainOrRange=Gain2Code(m_logicalDevice,AI,-800.0);
	m_pSR->channels.numberFormat=tNATIVE; //use the native format (integer counts)

	// buffer info
	m_pSR->lpBuffers=(DL_BUFFERLIST*) new BYTE[DL_BufferListBytes(1)]; //create a buffer list pointer for one buffer
	m_pSR->lpBuffers->notify=NOTIFY; //enable the buffer filled message
	m_pSR->lpBuffers->nBuffers=1; //use only one buffer
	m_pSR->lpBuffers->bufferSize=Samples2Bytes(m_logicalDevice,AI,m_logicalChannel,m_samples); //set the size of the buffer (in bytes) to hold the number of samples
	m_pSR->lpBuffers->BufferAddr[0]=BufAlloc(GBUF_INT,m_pSR->lpBuffers->bufferSize); //Allocate Buffer 0 based on the size we just specified

	// pacing info
	m_pSR->timing.typeEvent=RATEEVENT; //timing will be determined by the rate generator
	m_pSR->timing.u.rateEvent.channel=DEFAULTTIMER; //DEFAULTTIMER is a symbol representing the default counter/timer channel used for pacing.
	m_pSR->timing.u.rateEvent.mode=RATEGEN; //Set the counter/timer mode to burst generation
	m_pSR->timing.u.rateEvent.clock=INTERNAL1;  //Internal clocking will be used
	m_pSR->timing.u.rateEvent.gate=NOCONNECT; // no gating will be used
	m_pSR->timing.u.rateEvent.period=Sec2Tics(m_logicalDevice,AI,INTERNAL1,0.001f); //1000 Hz

	// check for state of auto zero check box
	UpdateData(TRUE);
	if (m_autoZero == TRUE)
	{
			m_pSR->channels.zeroRef = HARDWARE_ZEROREF;
	}
	else
	{
			m_pSR->channels.zeroRef = DISABLE_ZEROREF;
	}

	/*
		Auto Zero is a hardware feature of the KPCI-3108 and KPCI-3107 boards.
		These are the only boards in KPCI line which have this feature, therefore
		this example is suitable only for kpci3108 driver.

		When auto zero is turned on, the A/D converter is connected to an internal
		zero volt reference.  The digial trim pots are adjusted for a zero volt reading.

		Since an internal zero volt reference is used, the auto zero feature cannot be
		used to "subtract off" small offsets in your applied external signal.
		
    */
	
	DriverLINX(m_pSR); //Execute the service request to start the acquisition
	showMessage(m_pSR); //show any errors
	m_task=m_pSR->taskId; //Need to save the task ID of the AI task so it can be stopped later
	/*See the WindowProc function to see what happens next*/
}

void CAIbufferDlg::clearBuffers()
{
	/*Make sure the service request exists first, otherwise bad things
	happen if we try to act on a pointer which may be pointing anywhere*/
	if(m_pSR!=NULL)
	{
		/*If the service request exists, make sure there is a buffer list,
		for the same reason*/
		if(m_pSR->lpBuffers!=NULL)
		{
			/*If the buffer list exists, is there actually a pointer to
			a buffer?*/
			if(m_pSR->lpBuffers->BufferAddr[0]!=NULL)
			{
				/*De-allocate the buffer, and clear its pointer*/
				BufFree(m_pSR->lpBuffers->BufferAddr[0]);
				m_pSR->lpBuffers->BufferAddr[0]=NULL;
			}
			/*Delete the buffer list, we don't need it anymore*/
			delete(m_pSR->lpBuffers); 
			m_pSR->lpBuffers=NULL;
		}
	}
}

LRESULT CAIbufferDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
	if(message==m_DLmsg) //Did DriverLINX post a message?  We only want to act on the DriverLINX buffer filled message
	{
		switch(wParam)
		{
		case DL_BUFFERFILLED: //Was the DriverLINX message the buffer filled message?
			//done(); //if so, call the done() function to process the results
			break;
        case DL_SERVICEDONE:
			done();  // or we can call our done function from the ServiceDone message
			break;
		}
	}

	return CDialog::WindowProc(message, wParam, lParam);
}

void CAIbufferDlg::done()
{
	float *readings;
	readings = new float[m_samples]; //make a temporary array to hold the converted readings
	CString str; //The CString class includes a format method to convert float to CString to display them in the listbox
	char chanIndex[30];
	int index;
	/*The convert operation used here is taking advantage of the fact
	that the logical device number and the subsystem (AI) have already
	been set in the start request*/
	m_pSR->operation=CONVERT; //Use the convert operation to convert the raw counts in the buffer to voltages
	m_pSR->mode=OTHER;  //Convert is not a polled, interrupt, or DMA operation
	m_pSR->start.typeEvent=DATACONVERT; //Set the start type to convert the data
	m_pSR->start.u.dataConvert.startIndex=0; //start at index 0 of the buffer
	m_pSR->start.u.dataConvert.nSamples=m_samples; //set the number of samples to convert
	m_pSR->start.u.dataConvert.numberFormat=tSINGLE; //convert the counts to tSINGLE (float)
	m_pSR->start.u.dataConvert.scaling=0.0f; //no scaling will be used
	m_pSR->start.u.dataConvert.offset=0.0f; //no offset will be applied
	m_pSR->start.u.dataConvert.wBuffer=0; //convert DriverLINX buffer 0, since that's the only one being used
	m_pSR->start.u.dataConvert.lpBuffer=readings; //put the converted readings in the temporary buffer
	DriverLINX(m_pSR); //Execute the conversion
	showMessage(m_pSR); //show any errors
	m_readList.ResetContent(); //clear the listbox
	for(index=0;index<m_samples;index++)
	{
       strcpy(chanIndex,"chan #: ");
	   str.Format("%d",index);
	   strcat(chanIndex,str);  
       strcat(chanIndex," ");  // build a string of indexed chans
	   str.Format("%10.6f",readings[index]); //format the float reading into a string for each reading
	   strcat(chanIndex,str);  // add the reading onto end
	   m_readList.AddString(chanIndex); //Add the string to the listbox
	}
	UpdateData(FALSE); //Update the listbox display
	delete [] readings; //clear the temporary buffer so we don't have memory leaks when we run it again
	m_startButton.EnableWindow(TRUE);
	/*See the OnQuit() function to see what happens what needs to be done
	when the application closes*/
}



void CAIbufferDlg::OnOpenInit() 
{
	m_logicalDevice=0; //Set for the DriverLINX logical device being used
	m_logicalChannel=0; //Use channel 0 by default
	m_samples=8; //Set the number of samples to acquire here
	// the buffer size MUST be a multiple of the number of channels
	m_DLmsg=RegisterWindowMessage(DL_MESSAGE); //need to register DriverLINX messages to detect buffer filled message
	// pass in driver name to avoid the Open DriverLINX dialog
	m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3108$"); //Open DriverLINX driver
	//  give name of driver to avoid the dialog box to pick a driver
	// append the $ onto end of driver name to suppress the Open Driver dialog
	// in the event that the supplied driver name, kpci3108, fails to open (not installed).
	m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
	memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
	DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
	m_pSR->device=m_logicalDevice; //set the device number to the device being used
	m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
	m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
	m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
	m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
	if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_startButton.EnableWindow(TRUE);  // enable the Start button
}
else
{  // problem has occured
	showMessage(m_pSR); } // display the error message box

CWnd::SetActiveWindow();  // set focus back to our dialog	
}
